/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.tuples;

import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LPPosition
extends Triplet<Double, Double, Double> {
    public LPPosition(double xPos, double yPos, double zPos) {
        super(xPos, yPos, zPos);
    }

    public LPPosition(int xPos, int yPos, int zPos) {
        super(Double.valueOf(xPos), Double.valueOf(yPos), Double.valueOf(zPos));
    }

    public LPPosition(TileEntity tile) {
        super(Double.valueOf(tile.field_145851_c), Double.valueOf(tile.field_145848_d), Double.valueOf(tile.field_145849_e));
    }

    public LPPosition(CoreUnroutedPipe pipe) {
        super(Double.valueOf(pipe.getX()), Double.valueOf(pipe.getY()), Double.valueOf(pipe.getZ()));
    }

    public LPPosition(IPipeInformationProvider pipe) {
        super(Double.valueOf(pipe.getX()), Double.valueOf(pipe.getY()), Double.valueOf(pipe.getZ()));
    }

    public LPPosition(CoordinatesPacket packet) {
        super(Double.valueOf(packet.getPosX()), Double.valueOf(packet.getPosY()), Double.valueOf(packet.getPosZ()));
    }

    public LPPosition(Entity entity) {
        super(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public int getX() {
        return (int)((Double)this.getValue1()).doubleValue();
    }

    public int getY() {
        return (int)((Double)this.getValue2()).doubleValue();
    }

    public int getZ() {
        return (int)((Double)this.getValue3()).doubleValue();
    }

    public double getXD() {
        return (Double)this.getValue1();
    }

    public double getYD() {
        return (Double)this.getValue2();
    }

    public double getZD() {
        return (Double)this.getValue3();
    }

    public TileEntity getTileEntity(World world) {
        return world.func_147438_o(this.getX(), this.getY(), this.getZ());
    }

    public LPPosition moveForward(ForgeDirection dir, double steps) {
        switch (dir) {
            case UP: {
                this.value2 = (Double)this.value2 + steps;
                break;
            }
            case DOWN: {
                this.value2 = (Double)this.value2 - steps;
                break;
            }
            case NORTH: {
                this.value3 = (Double)this.value3 - steps;
                break;
            }
            case SOUTH: {
                this.value3 = (Double)this.value3 + steps;
                break;
            }
            case EAST: {
                this.value1 = (Double)this.value1 + steps;
                break;
            }
            case WEST: {
                this.value1 = (Double)this.value1 - steps;
                break;
            }
        }
        return this;
    }

    public LPPosition moveForward(ForgeDirection dir) {
        return this.moveForward(dir, 1.0);
    }

    public LPPosition moveBackward(ForgeDirection dir, double steps) {
        return this.moveForward(dir, -1.0 * steps);
    }

    public LPPosition moveBackward(ForgeDirection dir) {
        return this.moveBackward(dir, 1.0);
    }

    @Override
    public String toString() {
        return "(" + this.getXD() + ", " + this.getYD() + ", " + this.getZD() + ")";
    }

    public String toIntBasedString() {
        return "(" + this.getXD() + ", " + this.getYD() + ", " + this.getZD() + ")";
    }

    @Override
    public LPPosition copy() {
        return new LPPosition((Double)this.value1, (Double)this.value2, (Double)this.value3);
    }

    public Block getBlock(IBlockAccess world) {
        return world.func_147439_a(this.getX(), this.getY(), this.getZ());
    }

    public boolean blockExists(World world) {
        return world.func_72899_e(this.getX(), this.getY(), this.getZ());
    }

    public double distanceTo(LPPosition targetPos) {
        return Math.sqrt(Math.pow(targetPos.getXD() - this.getXD(), 2.0) + Math.pow(targetPos.getYD() - this.getYD(), 2.0) + Math.pow(targetPos.getZD() - this.getZD(), 2.0));
    }

    public LPPosition center() {
        this.value1 = (Double)this.value1 + 0.5;
        this.value2 = (Double)this.value2 + 0.5;
        this.value3 = (Double)this.value3 + 0.5;
        return this;
    }

    public void writeToNBT(String prefix, NBTTagCompound nbt) {
        nbt.func_74780_a(prefix + "xPos", ((Double)this.value1).doubleValue());
        nbt.func_74780_a(prefix + "yPos", ((Double)this.value2).doubleValue());
        nbt.func_74780_a(prefix + "zPos", ((Double)this.value3).doubleValue());
    }

    public static LPPosition readFromNBT(String prefix, NBTTagCompound nbt) {
        if (nbt.func_74764_b(prefix + "xPos") && nbt.func_74764_b(prefix + "yPos") && nbt.func_74764_b(prefix + "zPos")) {
            return new LPPosition(nbt.func_74769_h(prefix + "xPos"), nbt.func_74769_h(prefix + "yPos"), nbt.func_74769_h(prefix + "zPos"));
        }
        return null;
    }
}

