/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.BufferTransfer;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;

public class ServerPacketBufferHandlerThread {
    private final ServerCompressorThread serverCompressorThread = new ServerCompressorThread();
    private final ServerDecompressorThread serverDecompressorThread = new ServerDecompressorThread();

    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.serverDecompressorThread.serverTickEnd();
    }

    public void setPause(boolean flag) {
        this.serverCompressorThread.setPause(flag);
    }

    public void addPacketToCompressor(ModernPacket packet, EntityPlayer player) {
        this.serverCompressorThread.addPacketToCompressor(packet, player);
    }

    public void handlePacket(byte[] content, EntityPlayer player) {
        this.serverDecompressorThread.handlePacket(content, player);
    }

    private static byte[] compress(byte[] content) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gzipOutputStream.write(content);
            gzipOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] decompress(byte[] contentBytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(contentBytes));
            int buffer = 0;
            while ((buffer = gzip.read()) != -1) {
                out.write(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    public void clear(final EntityPlayer player) {
        new Thread(){

            @Override
            public void run() {
                ServerPacketBufferHandlerThread.this.serverCompressorThread.clear(player);
                ServerPacketBufferHandlerThread.this.serverDecompressorThread.clear(player);
            }
        }.start();
    }

    private class ServerDecompressorThread
    extends Thread {
        private final HashMap<EntityPlayer, LinkedList<byte[]>> queue;
        private final HashMap<EntityPlayer, byte[]> ByteBuffer;
        private final LinkedList<Pair<EntityPlayer, byte[]>> PacketBuffer;
        private Queue<EntityPlayer> playersToClear;

        public ServerDecompressorThread() {
            super("LogisticsPipes Packet Decompressor Server");
            this.queue = new HashMap();
            this.ByteBuffer = new HashMap();
            this.PacketBuffer = new LinkedList();
            this.playersToClear = new LinkedList<EntityPlayer>();
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serverTickEnd() {
            boolean flag = false;
            do {
                flag = false;
                Pair<EntityPlayer, byte[]> part = null;
                LinkedList<Pair<EntityPlayer, byte[]>> linkedList = this.PacketBuffer;
                synchronized (linkedList) {
                    if (this.PacketBuffer.size() > 0) {
                        flag = true;
                        part = this.PacketBuffer.pop();
                    }
                }
                if (!flag) continue;
                try {
                    PacketHandler.onPacketData(new LPDataInputStream(part.getValue2()), part.getValue1());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } while (flag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            while (true) {
                byte[] ByteBufferForPlayer;
                boolean flag = false;
                do {
                    void var3_7;
                    flag = false;
                    byte[] buffer = null;
                    Object var3_5 = null;
                    HashMap<EntityPlayer, LinkedList<byte[]>> hashMap = this.queue;
                    synchronized (hashMap) {
                        if (this.queue.size() > 0) {
                            Iterator<Map.Entry<EntityPlayer, LinkedList<byte[]>>> it = this.queue.entrySet().iterator();
                            while (it.hasNext()) {
                                Map.Entry<EntityPlayer, LinkedList<byte[]>> lPlayer = it.next();
                                if (lPlayer.getValue().size() > 0) {
                                    flag = true;
                                    buffer = lPlayer.getValue().getFirst();
                                    EntityPlayer entityPlayer = lPlayer.getKey();
                                    if (lPlayer.getValue().size() > 1) {
                                        lPlayer.getValue().removeFirst();
                                        break;
                                    }
                                    it.remove();
                                    break;
                                }
                                it.remove();
                            }
                        }
                    }
                    if (!flag || buffer == null || var3_7 == null) continue;
                    ByteBufferForPlayer = this.ByteBuffer.get(var3_7);
                    if (ByteBufferForPlayer == null) {
                        ByteBufferForPlayer = new byte[]{};
                        this.ByteBuffer.put((EntityPlayer)var3_7, ByteBufferForPlayer);
                    }
                    byte[] packetbytes = ServerPacketBufferHandlerThread.decompress(buffer);
                    byte[] newBuffer = new byte[packetbytes.length + ByteBufferForPlayer.length];
                    System.arraycopy(ByteBufferForPlayer, 0, newBuffer, 0, ByteBufferForPlayer.length);
                    System.arraycopy(packetbytes, 0, newBuffer, ByteBufferForPlayer.length, packetbytes.length);
                    this.ByteBuffer.put((EntityPlayer)var3_7, newBuffer);
                } while (flag);
                for (Map.Entry<EntityPlayer, byte[]> entry : this.ByteBuffer.entrySet()) {
                    int size;
                    while (entry.getValue().length >= 4 && (size = (((ByteBufferForPlayer = entry.getValue())[0] & 0xFF) << 24) + ((ByteBufferForPlayer[1] & 0xFF) << 16) + ((ByteBufferForPlayer[2] & 0xFF) << 8) + ((ByteBufferForPlayer[3] & 0xFF) << 0)) + 4 <= ByteBufferForPlayer.length) {
                        byte[] packet = Arrays.copyOfRange(ByteBufferForPlayer, 4, size + 4);
                        ByteBufferForPlayer = Arrays.copyOfRange(ByteBufferForPlayer, size + 4, ByteBufferForPlayer.length);
                        entry.setValue(ByteBufferForPlayer);
                        LinkedList<Pair<EntityPlayer, byte[]>> linkedList = this.PacketBuffer;
                        synchronized (linkedList) {
                            this.PacketBuffer.add(new Pair<EntityPlayer, byte[]>(entry.getKey(), packet));
                        }
                    }
                }
                Iterator<byte[]> it = this.ByteBuffer.values().iterator();
                while (it.hasNext()) {
                    byte[] byArray = it.next();
                    if (byArray.length != 0) continue;
                    it.remove();
                }
                Object object = this.queue;
                synchronized (object) {
                    while (this.queue.size() == 0) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                object = this.playersToClear;
                synchronized (object) {
                    EntityPlayer entityPlayer;
                    Object var3_14 = null;
                    do {
                        if ((entityPlayer = this.playersToClear.poll()) == null) continue;
                        this.ByteBuffer.remove(entityPlayer);
                    } while (entityPlayer != null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handlePacket(byte[] content, EntityPlayer player) {
            HashMap<EntityPlayer, LinkedList<byte[]>> hashMap = this.queue;
            synchronized (hashMap) {
                LinkedList<Object> list = this.queue.get(player);
                if (list == null) {
                    list = new LinkedList();
                    this.queue.put(player, list);
                }
                list.addLast(content);
                this.queue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear(EntityPlayer player) {
            Object object = this.queue;
            synchronized (object) {
                this.queue.remove(player);
            }
            object = this.playersToClear;
            synchronized (object) {
                this.playersToClear.add(player);
            }
        }
    }

    private class ServerCompressorThread
    extends Thread {
        private final HashMap<EntityPlayer, LinkedList<ModernPacket>> serverList;
        private final HashMap<EntityPlayer, byte[]> serverBuffer;
        private boolean pause;
        private Queue<EntityPlayer> playersToClear;

        public ServerCompressorThread() {
            super("LogisticsPipes Packet Compressor Server");
            this.serverList = new HashMap();
            this.serverBuffer = new HashMap();
            this.pause = false;
            this.playersToClear = new LinkedList<EntityPlayer>();
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object;
                try {
                    object = this.serverList;
                    synchronized (object) {
                        if (!this.pause) {
                            for (Map.Entry<EntityPlayer, LinkedList<ModernPacket>> player : this.serverList.entrySet()) {
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                DataOutputStream data = new DataOutputStream(out);
                                byte[] towrite = this.serverBuffer.get(player.getKey());
                                if (towrite != null) {
                                    data.write(towrite);
                                }
                                LinkedList<ModernPacket> packets = player.getValue();
                                for (ModernPacket packet : packets) {
                                    LPDataOutputStream t = new LPDataOutputStream();
                                    t.writeShort(packet.getId());
                                    t.writeInt(packet.getDebugId());
                                    try {
                                        packet.writeData(t);
                                    }
                                    catch (ConcurrentModificationException e) {
                                        throw new RuntimeException("LogisticsPipes error (please report): Method writeData is not thread-safe in packet " + packet.getClass().getSimpleName(), e);
                                    }
                                    data.writeInt(t.size());
                                    data.write(t.toByteArray());
                                }
                                this.serverBuffer.put(player.getKey(), out.toByteArray());
                            }
                            this.serverList.clear();
                        }
                    }
                    for (Map.Entry<EntityPlayer, byte[]> entry : this.serverBuffer.entrySet()) {
                        byte[] sendbuffer;
                        while (entry.getValue().length > 32768) {
                            sendbuffer = Arrays.copyOf(entry.getValue(), 32768);
                            byte[] newbuffer = Arrays.copyOfRange(entry.getValue(), 32768, entry.getValue().length);
                            entry.setValue(newbuffer);
                            byte[] compressed = ServerPacketBufferHandlerThread.compress(sendbuffer);
                            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(BufferTransfer.class).setContent(compressed), entry.getKey());
                        }
                        sendbuffer = entry.getValue();
                        byte[] compressed = ServerPacketBufferHandlerThread.compress(sendbuffer);
                        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(BufferTransfer.class).setContent(compressed), entry.getKey());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.serverBuffer.clear();
                object = this.serverList;
                synchronized (object) {
                    while (this.pause || this.serverList.size() == 0) {
                        try {
                            this.serverList.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                object = this.playersToClear;
                synchronized (object) {
                    EntityPlayer entityPlayer;
                    Object var2_10 = null;
                    do {
                        if ((entityPlayer = this.playersToClear.poll()) == null) continue;
                        this.serverBuffer.remove(entityPlayer);
                    } while (entityPlayer != null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPacketToCompressor(ModernPacket packet, EntityPlayer player) {
            HashMap<EntityPlayer, LinkedList<ModernPacket>> hashMap = this.serverList;
            synchronized (hashMap) {
                LinkedList<ModernPacket> packetList = this.serverList.get(player);
                if (packetList == null) {
                    packetList = new LinkedList();
                    this.serverList.put(player, packetList);
                }
                packetList.add(packet);
                if (!this.pause) {
                    this.serverList.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPause(boolean flag) {
            HashMap<EntityPlayer, LinkedList<ModernPacket>> hashMap = this.serverList;
            synchronized (hashMap) {
                this.pause = flag;
                if (!this.pause) {
                    this.serverList.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear(EntityPlayer player) {
            Object object = this.serverList;
            synchronized (object) {
                this.serverList.remove(player);
            }
            object = this.playersToClear;
            synchronized (object) {
                this.playersToClear.add(player);
            }
        }
    }
}

