/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class DSUInventoryHandler
extends SpecialInventoryHandler {
    private final IDeepStorageUnit _tile;
    private final boolean _hideOnePerStack;

    private DSUInventoryHandler(TileEntity tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._tile = (IDeepStorageUnit)tile;
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public DSUInventoryHandler() {
        this._tile = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(TileEntity tile) {
        return tile instanceof IDeepStorageUnit;
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(TileEntity tile, ForgeDirection dir, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new DSUInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public int itemCount(ItemIdentifier itemIdent) {
        ItemStack items = this._tile.getStoredItemType();
        if (items != null && ItemIdentifier.get(items).equals(itemIdent)) {
            return items.field_77994_a - (this._hideOnePerStack ? 1 : 0);
        }
        return 0;
    }

    @Override
    public ItemStack getMultipleItems(ItemIdentifier itemIdent, int count) {
        ItemStack items = this._tile.getStoredItemType();
        if (items == null || !ItemIdentifier.get(items).equals(itemIdent)) {
            return null;
        }
        if (this._hideOnePerStack) {
            --items.field_77994_a;
        }
        if (count >= items.field_77994_a) {
            this._tile.setStoredItemCount(this._hideOnePerStack ? 1 : 0);
            return items;
        }
        ItemStack newItems = items.func_77979_a(count);
        this._tile.setStoredItemCount(items.field_77994_a + (this._hideOnePerStack ? 1 : 0));
        return newItems;
    }

    @Override
    public Set<ItemIdentifier> getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        ItemStack items = this._tile.getStoredItemType();
        if (items != null && items.field_77994_a > 0) {
            result.add(ItemIdentifier.get(items));
        }
        return result;
    }

    public HashMap<ItemIdentifier, Integer> getItemsAndCount() {
        HashMap<ItemIdentifier, Integer> result = new HashMap<ItemIdentifier, Integer>();
        ItemStack items = this._tile.getStoredItemType();
        if (items != null && items.field_77994_a > 0) {
            result.put(ItemIdentifier.get(items), items.field_77994_a - (this._hideOnePerStack ? 1 : 0));
        }
        return result;
    }

    @Override
    public ItemStack getSingleItem(ItemIdentifier itemIdent) {
        return this.getMultipleItems(itemIdent, 1);
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier itemIdent) {
        ItemStack items = this._tile.getStoredItemType();
        return items != null && ItemIdentifier.get(items).getUndamaged().equals(itemIdent);
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, 0);
    }

    @Override
    public int roomForItem(ItemIdentifier itemIdent, int count) {
        if (itemIdent.tag != null) {
            return 0;
        }
        ItemStack items = this._tile.getStoredItemType();
        if (items == null) {
            return this._tile.getMaxStoredCount();
        }
        if (ItemIdentifier.get(items).equals(itemIdent)) {
            return this._tile.getMaxStoredCount() - items.field_77994_a;
        }
        return 0;
    }

    @Override
    public ItemStack add(ItemStack stack, ForgeDirection from, boolean doAdd) {
        ItemStack st = stack.func_77946_l();
        st.field_77994_a = 0;
        if (stack.func_77978_p() != null) {
            return st;
        }
        ItemStack items = this._tile.getStoredItemType();
        if (items == null || items.field_77994_a == 0) {
            if (stack.field_77994_a <= this._tile.getMaxStoredCount()) {
                this._tile.setStoredItemType(stack, stack.field_77994_a);
                st.field_77994_a = stack.field_77994_a;
                return st;
            }
            this._tile.setStoredItemType(stack, this._tile.getMaxStoredCount());
            st.field_77994_a = this._tile.getMaxStoredCount();
            return st;
        }
        if (!items.func_77969_a(stack)) {
            return st;
        }
        if (stack.field_77994_a <= this._tile.getMaxStoredCount() - items.field_77994_a) {
            this._tile.setStoredItemCount(items.field_77994_a + stack.field_77994_a);
            st.field_77994_a = stack.field_77994_a;
            return st;
        }
        this._tile.setStoredItemCount(this._tile.getMaxStoredCount());
        st.field_77994_a = this._tile.getMaxStoredCount() - items.field_77994_a;
        return st;
    }

    @Override
    public boolean isSpecialInventory() {
        return true;
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        if (i != 0) {
            return null;
        }
        return this._tile.getStoredItemType();
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        if (i != 0) {
            return null;
        }
        return this.getMultipleItems(ItemIdentifier.get(this._tile.getStoredItemType()), j);
    }
}

