/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.buildcraft.robots;

import buildcraft.api.core.IZone;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.robotics.RobotStationPluggable;
import buildcraft.transport.TileGenericPipe;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.routing.ISpecialPipedConnection;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.robots.boards.LogisticsRoutingBoardRobot;
import logisticspipes.proxy.specialconnection.SpecialPipeConnection;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.utils.tuples.LPPosition;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LPRobotConnectionControl
implements ISpecialPipedConnection {
    private final Map<World, Set<Pair<LPPosition, ForgeDirection>>> globalAvailableRobots = new WeakHashMap<World, Set<Pair<LPPosition, ForgeDirection>>>();
    public static final LPRobotConnectionControl instance = new LPRobotConnectionControl();

    public void addRobot(World world, LPPosition pos, ForgeDirection dir) {
        if (this.globalAvailableRobots.get(world) == null) {
            this.globalAvailableRobots.put(world, new HashSet());
        }
        this.globalAvailableRobots.get(world).add(new Pair<LPPosition, ForgeDirection>(pos, dir));
        this.checkAll(world);
    }

    public void removeRobot(World world, LPPosition pos, ForgeDirection dir) {
        if (this.globalAvailableRobots.containsKey(world)) {
            this.globalAvailableRobots.get(world).remove(new Pair<LPPosition, ForgeDirection>(pos, dir));
        }
        this.checkAll(world);
    }

    public void checkAll(World world) {
        if (!this.globalAvailableRobots.containsKey(world)) {
            return;
        }
        for (Pair<LPPosition, ForgeDirection> canidatePos : this.globalAvailableRobots.get(world)) {
            LogisticsRoutingBoardRobot lpBoard;
            EntityRobotBase connectedRobot;
            DockingStation connectedStation;
            PipePluggable connectedPluggable;
            LogisticsTileGenericPipe connectedPipe;
            TileEntity connectedPipeTile = canidatePos.getValue1().getTileEntity(world);
            if (!(connectedPipeTile instanceof LogisticsTileGenericPipe) || !(connectedPipe = (LogisticsTileGenericPipe)connectedPipeTile).isRoutingPipe() || !((connectedPluggable = ((TileGenericPipe)connectedPipe.tilePart.getOriginal()).getPipePluggable(canidatePos.getValue2())) instanceof RobotStationPluggable) || !(connectedStation = ((RobotStationPluggable)connectedPluggable).getStation()).isTaken() || (connectedRobot = connectedStation.robotTaking()) == null || !(connectedRobot.getBoard() instanceof LogisticsRoutingBoardRobot) || !this.isModified(lpBoard = (LogisticsRoutingBoardRobot)connectedRobot.getBoard())) continue;
            connectedPipe.getRoutingPipe().triggerConnectionCheck();
        }
    }

    public boolean isModified(LogisticsRoutingBoardRobot board) {
        HashSet<Pair<LPPosition, ForgeDirection>> localConnectedRobots = new HashSet<Pair<LPPosition, ForgeDirection>>();
        LPPosition sourceRobotPosition = board.getLinkedStationPosition().center().moveForward(board.robot.getLinkedStation().side(), 0.5);
        IZone zone = board.robot.getZoneToWork();
        for (Pair<LPPosition, ForgeDirection> canidatePos : this.globalAvailableRobots.get(board.robot.field_70170_p)) {
            boolean isPartOfZone;
            LPPosition canidateRobotPosition = canidatePos.getValue1().copy().center().moveForward(canidatePos.getValue2(), 0.5);
            double distance = canidateRobotPosition.distanceTo(sourceRobotPosition);
            if (zone != null) {
                isPartOfZone = zone.contains(canidateRobotPosition.getXD(), canidateRobotPosition.getYD(), canidateRobotPosition.getZD());
            } else {
                boolean bl = isPartOfZone = distance < (double)Configs.MAX_ROBOT_DISTANCE;
            }
            if (!isPartOfZone) continue;
            localConnectedRobots.add(canidatePos);
        }
        if (board.getConnectionDetails().localConnectedRobots.equals(localConnectedRobots)) {
            return false;
        }
        board.getConnectionDetails().localConnectedRobots.clear();
        board.getConnectionDetails().localConnectedRobots.addAll(localConnectedRobots);
        return true;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(IPipeInformationProvider startPipe) {
        if (!(startPipe instanceof LogisticsTileGenericPipe)) {
            return false;
        }
        LogisticsTileGenericPipe pipe = (LogisticsTileGenericPipe)startPipe;
        return pipe.isRoutingPipe();
    }

    @Override
    public List<SpecialPipeConnection.ConnectionInformation> getConnections(IPipeInformationProvider startPipe, EnumSet<PipeRoutingConnectionType> connection, ForgeDirection side) {
        ArrayList<SpecialPipeConnection.ConnectionInformation> list = new ArrayList<SpecialPipeConnection.ConnectionInformation>();
        LogisticsTileGenericPipe pipe = (LogisticsTileGenericPipe)startPipe;
        if (pipe == null || pipe.tilePart.getOriginal() == null) {
            return list;
        }
        LPPosition pos = new LPPosition(startPipe);
        pos.center();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            EntityRobotBase robot;
            DockingStation station;
            PipePluggable pluggable = ((TileGenericPipe)pipe.tilePart.getOriginal()).getPipePluggable(dir);
            if (!(pluggable instanceof RobotStationPluggable) || !(station = ((RobotStationPluggable)pluggable).getStation()).isTaken() || (robot = station.robotTaking()) == null || !(robot.getBoard() instanceof LogisticsRoutingBoardRobot) || robot.field_70128_L || !((LogisticsRoutingBoardRobot)robot.getBoard()).isAcceptsItems()) continue;
            LPPosition robotPos = new LPPosition((Entity)robot);
            if (((LogisticsRoutingBoardRobot)robot.getBoard()).getCurrentTarget() != null) {
                LogisticsTileGenericPipe connectedPipe;
                Pair<Double, LogisticsRoutingBoardRobot> currentTarget = ((LogisticsRoutingBoardRobot)robot.getBoard()).getCurrentTarget();
                LPPosition pipePos = currentTarget.getValue2().getLinkedStationPosition();
                TileEntity connectedPipeTile = pipePos.getTileEntity(pipe.func_145831_w());
                if (!(connectedPipeTile instanceof LogisticsTileGenericPipe) || !(connectedPipe = (LogisticsTileGenericPipe)connectedPipeTile).isRoutingPipe()) continue;
                IPipeInformationProvider connectedInfo = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(connectedPipe);
                EntityRobotBase connectedRobot = currentTarget.getValue2().robot;
                if (connectedRobot == null || !(connectedRobot.getBoard() instanceof LogisticsRoutingBoardRobot) || connectedRobot.field_70128_L || connectedRobot.getZoneToWork() != null && !connectedRobot.getZoneToWork().contains(robotPos.getXD(), robotPos.getYD(), robotPos.getZD()) || !((LogisticsRoutingBoardRobot)connectedRobot.getBoard()).isAcceptsItems()) continue;
                LPPosition connectedRobotPos = new LPPosition((Entity)connectedRobot);
                if (pipePos.copy().center().moveForward(currentTarget.getValue2().robot.getLinkedStation().side(), 0.5).distanceTo(connectedRobotPos) > 0.05) continue;
                Object newCon = connection.clone();
                ((AbstractSet)newCon).removeAll(EnumSet.of(PipeRoutingConnectionType.canPowerFrom, PipeRoutingConnectionType.canPowerSubSystemFrom));
                double distance = currentTarget.getValue2().getLinkedStationPosition().copy().center().moveForward(currentTarget.getValue2().robot.getLinkedStation().side(), 0.5).distanceTo(robotPos);
                list.add(new SpecialPipeConnection.ConnectionInformation(connectedInfo, (EnumSet<PipeRoutingConnectionType>)newCon, currentTarget.getValue2().robot.getLinkedStation().side().getOpposite(), dir, distance * 3.0 + 21.0));
                continue;
            }
            if (pos.copy().moveForward(dir, 0.5).distanceTo(robotPos) > 0.05) continue;
            for (Pair<LPPosition, ForgeDirection> canidatePos : ((LogisticsRoutingBoardRobot)robot.getBoard()).getConnectionDetails().localConnectedRobots) {
                EntityRobotBase connectedRobot;
                DockingStation connectedStation;
                LogisticsTileGenericPipe connectedPipe;
                if (canidatePos.getValue1().equals(new LPPosition(startPipe))) continue;
                double distance = canidatePos.getValue1().copy().center().moveForward(canidatePos.getValue2(), 0.5).distanceTo(robotPos);
                TileEntity connectedPipeTile = canidatePos.getValue1().getTileEntity(pipe.func_145831_w());
                if (!(connectedPipeTile instanceof LogisticsTileGenericPipe) || !(connectedPipe = (LogisticsTileGenericPipe)connectedPipeTile).isRoutingPipe()) continue;
                IPipeInformationProvider connectedInfo = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(connectedPipe);
                PipePluggable connectedPluggable = ((TileGenericPipe)connectedPipe.tilePart.getOriginal()).getPipePluggable(canidatePos.getValue2());
                if (!(connectedPluggable instanceof RobotStationPluggable) || !(connectedStation = ((RobotStationPluggable)connectedPluggable).getStation()).isTaken() || (connectedRobot = connectedStation.robotTaking()) == null || !(connectedRobot.getBoard() instanceof LogisticsRoutingBoardRobot) || connectedRobot.field_70128_L || connectedRobot.getZoneToWork() != null && !connectedRobot.getZoneToWork().contains(robotPos.getXD(), robotPos.getYD(), robotPos.getZD()) || !((LogisticsRoutingBoardRobot)connectedRobot.getBoard()).isAcceptsItems() || ((LogisticsRoutingBoardRobot)connectedRobot.getBoard()).getCurrentTarget() != null && ((LogisticsRoutingBoardRobot)connectedRobot.getBoard()).getCurrentTarget().getValue2() != robot.getBoard()) continue;
                LPPosition connectedRobotPos = new LPPosition((Entity)connectedRobot);
                if (canidatePos.getValue1().copy().center().moveForward(canidatePos.getValue2(), 0.5).distanceTo(connectedRobotPos) > 0.05) continue;
                Object newCon = connection.clone();
                ((AbstractSet)newCon).removeAll(EnumSet.of(PipeRoutingConnectionType.canPowerFrom, PipeRoutingConnectionType.canPowerSubSystemFrom));
                list.add(new SpecialPipeConnection.ConnectionInformation(connectedInfo, (EnumSet<PipeRoutingConnectionType>)newCon, canidatePos.getValue2().getOpposite(), dir, distance * 3.0 + 21.0));
            }
        }
        return list;
    }

    public void cleanup() {
        this.globalAvailableRobots.clear();
    }

    private LPRobotConnectionControl() {
    }

    public static class RobotConnection {
        public final Set<Pair<LPPosition, ForgeDirection>> localConnectedRobots = new HashSet<Pair<LPPosition, ForgeDirection>>();
    }
}

