/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks.powertile;

import ic2.api.energy.tile.IEnergySink;
import logisticspipes.asm.ModDependentInterface;
import logisticspipes.asm.ModDependentMethod;
import logisticspipes.blocks.powertile.LogisticsPowerProviderTileEntity;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.renderer.LogisticsHUDRenderer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@ModDependentInterface(modId={"IC2"}, interfacePath={"ic2.api.energy.tile.IEnergySink"})
public class LogisticsIC2PowerProviderTileEntity
extends LogisticsPowerProviderTileEntity
implements IEnergySink {
    public static final int MAX_STORAGE = 40000000;
    public static final int MAX_MAXMODE = 8;
    public static final int MAX_PROVIDE_PER_TICK = 12288;
    private boolean addedToEnergyNet = false;
    private boolean init = false;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.init && !this.addedToEnergyNet) {
            SimpleServiceLocator.IC2Proxy.registerToEneryNet(this);
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (MainProxy.isClient(this.getWorld())) {
            LogisticsHUDRenderer.instance().remove(this);
        }
        if (this.addedToEnergyNet) {
            SimpleServiceLocator.IC2Proxy.unregisterToEneryNet(this);
            this.addedToEnergyNet = false;
        }
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (MainProxy.isClient(this.getWorld())) {
            this.init = false;
        }
        if (!this.addedToEnergyNet) {
            this.init = false;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (MainProxy.isClient(this.getWorld())) {
            LogisticsHUDRenderer.instance().remove(this);
        }
        if (this.addedToEnergyNet) {
            SimpleServiceLocator.IC2Proxy.unregisterToEneryNet(this);
            this.addedToEnergyNet = false;
        }
    }

    public void addEnergy(float amount) {
        if (MainProxy.isClient(this.getWorld())) {
            return;
        }
        this.internalStorage += amount;
        if (this.internalStorage > 4.0E7f) {
            this.internalStorage = 4.0E7f;
        }
        if (this.internalStorage >= (float)this.getMaxStorage()) {
            this.needMorePowerTriggerCheck = false;
        }
    }

    public float freeSpace() {
        return (float)this.getMaxStorage() - this.internalStorage;
    }

    @Override
    public int getMaxStorage() {
        this.maxMode = Math.min(8, Math.max(1, this.maxMode));
        return 40000000 / this.maxMode;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
    }

    @Override
    public String getBrand() {
        return "EU";
    }

    @Override
    protected float getMaxProvidePerTick() {
        return 12288.0f;
    }

    @Override
    protected void handlePower(CoreRoutedPipe pipe, float toSend) {
        pipe.handleIC2PowerArival(toSend);
    }

    @Override
    protected int getLaserColor() {
        return 0xFFFF00;
    }

    @ModDependentMethod(modId="IC2")
    public boolean acceptsEnergyFrom(TileEntity tile, ForgeDirection dir) {
        return true;
    }

    @ModDependentMethod(modId="IC2")
    public double getDemandedEnergy() {
        return this.freeSpace();
    }

    @ModDependentMethod(modId="IC2")
    public int getSinkTier() {
        return Integer.MAX_VALUE;
    }

    @ModDependentMethod(modId="IC2")
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.addEnergy((float)amount);
        return 0.0;
    }
}

